<?php
function new_excerpt_length($length) {
	return 36;
}
add_filter('excerpt_length', 'new_excerpt_length');


add_theme_support('menus');

add_action( 'init', 'register_my_menus' );

function register_my_menus() {
	register_nav_menus(
		array(
			'pages-menu' => __( 'Pages Menu' ),
			'cats-menu' => __( 'Categories Menu' )
		)
	);
}

if ( function_exists('register_sidebars') )
    register_sidebars(4);
	
// breadcrump Navigation
function breadcrumbs() {

			_e('<p class="breadcrumb"><a href="') . _e( get_option('home') ) . _e('">') .  bloginfo('name') . _e('</a> &raquo; ');
			if ( is_category() ) {
				single_cat_title();
				//the_category(', ');
			} elseif ( is_single() ) {
					the_category(', ') . _e(' &raquo; ') . the_title();
			} elseif ( is_page() ) {
				_e( the_title() . '</p>');
			} elseif (is_page() && $post->post_parent ) {
				_e( get_the_title($post->post_parent) );
				_e(' &raquo; ');
				_e( the_title() );
			} elseif ( is_search() ) {
				_e('Search Results: ') . the_search_query() . _e('</p>');
			}

	}
// image pulling from posts	
function imagesrc() {
global $post, $posts;
$first_img = '';
ob_start();
ob_end_clean();
$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
if (isset($matches [1] [0])) {
	$first_img = $matches [1] [0];
	}
if (!($first_img))
{
	$attachments = get_children(array('post_parent' => get_the_ID(), 'post_type' => 'attachment', 'post_mime_type' => 'image', 'orderby' => 'menu_order'));
if (is_array($attachments) && !empty($attachments))
	{
	$count = count($attachments);
	$first_attachment = array_shift($attachments);
	$imgsrc = wp_get_attachment_image_src($first_attachment->ID, 'large');
	$first_img = $imgsrc[0];
	}
}
return $first_img;
}
?>